/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.my_util.SignalArged;

@OnlyIn(value=Dist.CLIENT)
@IPVanillaCopy
public class ImmPtlClientChunkMap
extends ClientChunkCache {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Long2ObjectOpenHashMap<LevelChunk> chunkMapForMainThread = new Long2ObjectOpenHashMap();
    protected final Long2ObjectOpenHashMap<LevelChunk> chunkMapForOtherThreads = new Long2ObjectOpenHashMap();
    public final Thread mainThread = ((IEMinecraftClient)Minecraft.m_91087_()).ip_getRunningThread();
    public static final SignalArged<LevelChunk> clientChunkLoadSignal = new SignalArged();
    public static final SignalArged<LevelChunk> clientChunkUnloadSignal = new SignalArged();

    public ImmPtlClientChunkMap(ClientLevel clientWorld, int loadDistance) {
        super(clientWorld, 1);
    }

    public void m_104455_(int x, int z) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        ChunkPos chunkPos = new ChunkPos(x, z);
        LevelChunk chunk = (LevelChunk)this.chunkMapForMainThread.get(chunkPos.m_45588_());
        if (chunk != null) {
            this.modifyChunkMap(chunkMap -> chunkMap.remove(chunkPos.m_45588_()));
            O_O.postClientChunkUnloadEvent(chunk);
            this.f_104411_.m_104665_(chunk);
            SodiumInterface.invoker.onClientChunkUnloaded(this.f_104411_, x, z);
            clientChunkUnloadSignal.emit(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readChunkMap(Function<Long2ObjectOpenHashMap<LevelChunk>, T> func) {
        if (Thread.currentThread() == this.mainThread) {
            return func.apply(this.chunkMapForMainThread);
        }
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = this.chunkMapForOtherThreads;
        synchronized (long2ObjectOpenHashMap) {
            return func.apply(this.chunkMapForOtherThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyChunkMap(Consumer<Long2ObjectOpenHashMap<LevelChunk>> func) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        func.accept(this.chunkMapForMainThread);
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = this.chunkMapForOtherThreads;
        synchronized (long2ObjectOpenHashMap) {
            func.accept(this.chunkMapForOtherThreads);
        }
    }

    public LevelChunk m_7587_(int x, int z, ChunkStatus chunkStatus, boolean create) {
        return this.readChunkMap(chunkMap -> {
            LevelChunk chunk = (LevelChunk)chunkMap.get(ChunkPos.m_45589_((int)x, (int)z));
            if (chunk != null) {
                return chunk;
            }
            return create ? this.f_104408_ : null;
        });
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.readChunkMap(chunkMap -> chunkMap.containsKey(ChunkPos.m_45589_((int)x, (int)z)));
    }

    public void m_274444_(int x, int z, FriendlyByteBuf friendlyByteBuf) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        long chunkPosLong = ChunkPos.m_45589_((int)x, (int)z);
        LevelChunk worldChunk = (LevelChunk)this.chunkMapForMainThread.get(chunkPosLong);
        ChunkPos chunkPos = new ChunkPos(x, z);
        if (worldChunk == null) {
            LOGGER.error("Trying to replace biomes for missing chunk {} {}", (Object)x, (Object)z);
        } else {
            worldChunk.m_274381_(friendlyByteBuf);
        }
    }

    public LevelChunk m_194116_(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        long chunkPosLong = ChunkPos.m_45589_((int)x, (int)z);
        LevelChunk worldChunk = (LevelChunk)this.chunkMapForMainThread.get(chunkPosLong);
        if (worldChunk == null) {
            worldChunk = new LevelChunk((Level)this.f_104411_, new ChunkPos(x, z));
            this.loadChunkDataFromPacket(buf, nbt, worldChunk, consumer);
            LevelChunk worldChunkToPut = worldChunk;
            this.modifyChunkMap(chunkMap -> chunkMap.put(chunkPosLong, (Object)worldChunkToPut));
        } else {
            this.loadChunkDataFromPacket(buf, nbt, worldChunk, consumer);
        }
        this.f_104411_.m_171649_(new ChunkPos(x, z));
        O_O.postClientChunkLoadEvent(worldChunk);
        SodiumInterface.invoker.onClientChunkLoaded(this.f_104411_, x, z);
        clientChunkLoadSignal.emit(worldChunk);
        return worldChunk;
    }

    private void loadChunkDataFromPacket(FriendlyByteBuf buf, CompoundTag nbt, LevelChunk worldChunk, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        try {
            worldChunk.m_187971_(buf, nbt, consumer);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing chunk packet {} {}", (Object)worldChunk.m_62953_().m_46472_().m_135782_(), (Object)worldChunk.m_7697_(), (Object)e);
            CHelper.printChat((Component)Component.m_237113_((String)"Failed to deserialize chunk packet. %s %s %s".formatted(worldChunk.m_62953_().m_46472_().m_135782_(), worldChunk.m_7697_().f_45578_, worldChunk.m_7697_().f_45579_)).m_7220_((Component)Component.m_237113_((String)" Report issue:")).m_7220_((Component)McHelper.getLinkText(O_O.getIssueLink())).m_130940_(ChatFormatting.RED));
            throw new RuntimeException(e);
        }
    }

    public List<LevelChunk> getCopiedChunkList() {
        return this.readChunkMap(chunkMap -> Arrays.asList((LevelChunk[])chunkMap.values().toArray((Object[])new LevelChunk[0])));
    }

    public void m_104459_(int x, int z) {
    }

    public void m_104416_(int r) {
    }

    public String m_6754_() {
        return "Client Chunks (ImmPtl) " + this.m_8482_();
    }

    public int m_8482_() {
        return this.readChunkMap(chunkMap -> chunkMap.size());
    }

    public void m_6506_(LightLayer lightType, SectionPos chunkSectionPos) {
        ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)this.f_104411_.m_46472_()).m_109770_(chunkSectionPos.m_123170_(), chunkSectionPos.m_123206_(), chunkSectionPos.m_123222_());
    }
}

